
#ifndef _1_CRYS_ATP_TST_RC4FLOW_Acceptance_h_H
#define _1_CRYS_ATP_TST_RC4FLOW_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_FLOW.h"

#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/
#if FLOW_RC4_Support

#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 14 10:18:14 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_DESFLOW_Acceptance.h#1:incl:1
   *  \author Annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
typedef struct TST_RC4FLOW_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];

	/* input interrupt id */
	DxUint32_t                  inputInterruptId;

	/* output interrupt id */
	DxUint32_t                  outputInterruptId;


	/* if the data in the buffers are in words and not bytes */ 
	DxUint32_t                  wordsBuffersOrderFlag;

	/* number of input buffers */
	DxUint16_t                  inputBuffersArraySize;

	/* input block size */
	//DxUint16_t                  blockSize;

	/* flag if  endian order of the input buffers is big */
	DxUint32_t                  inputBigEndianOrderFlag;

	/* number of input buffers */
	DxUint16_t                  outputBuffersArraySize;

	/* output block size */
	//DxUint16_t                  outputBlockSize;

	/* flag if  endian order of the output buffers is big */
	DxUint32_t                  outputBigEndianOrderFlag;

	DxUint8_t 			        TST_Expected_output_data[TST_FLOW_DATA_VEC_SIZE_IN_BYTS];
	
	DxUint8_t                   TST_Expected_cyclicOperation_data[TST_FLOW_DATA_VEC_SIZE_IN_BYTS];
	
	DxUint8_t 					TST_Key[TST_FLOW_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_KeySize;
	
    
	
} TST_RC4FLOW_TestDataStruct;


/************************ Public Variables **********************/
/************************ Public Functions **********************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_RC4STATIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static RC4 FLOW API's
 
 * Algorithm:     
 *	This function initializes RC4 flow with static type and other parameters,
 *  sends interrupts that input and output buffers are ready, finishes RC4 flow, 
 *  reads data from the output buffers and compare to expected results
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_RC4STATIC_Acceptance ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_RC4DYNAMIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static RC4 FLOW API's
 
 * Algorithm:     
 *	This function goes through all tests vectors and execute RC4 dynamic flow acceptance test
 *  for each vector
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_RC4DYNAMIC_Acceptance ( void );


/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_RC4DYNAMIC_AddBuffers_Acceptance
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for dynamic RC4 FLOW API's

* Algorithm:     
*	This function initializes RC4 flow with dynamic type and other parameters,
*  sends interrupts that input and output buffers are ready, adds buffers to
*  dynamic flow, finishes RC4 flow, 
*  reads data from the output buffers and compare to expected results
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_RC4DYNAMIC_AddBuffers_Acceptance ( void );


/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_RC4STATIC_Acceptance_WithAdditionalEngines
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for static RC4 FLOW API's with additional engines.

* Algorithm:     
*  This function goes through all flow vectors and execute acceptance test with 
*  additional engines for each vector
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_RC4STATIC_Acceptance_WithAdditionalEngines ( void );


/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_RC4DYNAMIC_Acceptance_WithAdditionalEngines
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for static RC4 FLOW API's with additional engines.

* Algorithm:     
*  This function goes through all flow vectors and execute acceptance test with 
*  additional engines for each vector
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_RC4DYNAMIC_Acceptance_WithAdditionalEngines ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_RC4STATIC_Cyclic_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static cyclic RC4 FLOW API's
 
 * Algorithm:     
 *	This function initializes RC4 flow with static type and other parameters,
 * and executes several times flow on the same input buffer. It goes throw all test
 * vectors and check cyclic acceptance.
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_RC4STATIC_Cyclic_Acceptance ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_RC4_ONETEST_Acceptance
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_MasterTestName - test name
 *  flowType           - flow type (static or dynamic)
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static AES FLOW API's
 
 * Algorithm:     
 *  1. Init RC4 flow
 *  2. Send interrupts that input and output buffers are ready
 *  3. Finish RC4 flow, read data from the output buffers and compare to expected results
 *  4. Terminate flow
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_RC4_ONETEST_Acceptance ( int              TST_index, 
                                                       char            *TST_MasterTestName,
                                                       CRYS_FLOW_Type_t flowType );
                                                       
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_RC4STATIC_ONETEST_Cyclic_Acceptance
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_MasterTestName - test name 
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static cyclic DES FLOW API's
 
 * Algorithm:     
 * 1. Initialize RC4 flow with static type and other parameters 
 * 2. Init RC4 flow
 * 3. Send interrupts to execute cyclic flow operation 
 * 4. Finish RC4 flow
 * 5. Get results
 * 6. Terminate flow
 * 7. Read data from the output buffers and compare to expected result
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_RC4STATIC_ONETEST_Cyclic_Acceptance ( int   TST_index,
                                                                    char *TST_MasterTestName ); 
                                                       


/************************ Private Functions **********************/


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_InitRC4Flow
 *  
 * Inputs:
 *  TST_index          - test index
 *  flowType           - flow type
 *  TST_MasterTestName - test name
 *  TST_RC4FlowId      - output RC4 flow id
 *  pRC4FlowParamsInfo - flow params info
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *	This function starts RC4 flow.
 *
 * Algorithm:     
 *	This function starts RC4 flow.
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_InitRC4Flow ( int                     TST_index,
                                       CRYS_FLOW_Type_t        flowType,
                                       char                   *TST_MasterTestName, 
                                       DxUint32_t             *TST_RC4FlowId,
                                       CRYS_FLOW_Params_t     *pRC4FlowParamsInfo );
                                       
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FinishRC4Flow
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_RC4            - flow id
 *  TST_MasterTestName - test name
 *  blockSize          - block size for finish
 *  pRC4FlowParamsInfo - flow params info
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *	This function finishes RC4 flow and checks results.
 *
 * Algorithm:     
 *	1. Finish RC4 flow
 *  2. Get results
 *  3. Compare output buffers with expected results
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FinishRC4Flow ( int                     TST_index, 
                                         DxUint32_t              TST_RC4FlowId, 
                                         char                   *TST_MasterTestName,
                                         DxUint32_t              blockSize,
                                         CRYS_FLOW_Params_t     *pRC4FlowParamsInfo );
                                       




#ifdef __cplusplus
}
#endif

#endif

#endif
#endif
